# -*- coding: cp1252 -*-
overrideIcon= "r_arnold_question"

######################################################################
#
# Name:  Collect CPU SSE 4.2 support to verify Arnold 4.2.13 can be executed on the machine
# Author:  Royal Render, Holger Schoenberger, Binary Alchemy
# Version: 
# Description: 
#   This tool creates a batch file that executes baCPUInfo.
#   The output is parsed by rrParseOutput which creates a .csv table (open it in e.g. Excel)
#   And it adds/removes the client to/from a client group "Arnold"
#
# Copyright (c) Holger Schoenberger - Binary Alchemy
######################################################################
import os


    



fileBaseName=rrGlobal.rrRootPath()+"inhouse\\rrCollectArnold"
if (not os.path.isdir(rrGlobal.rrRootPath()+"inhouse")):
    os.mkdir(rrGlobal.rrRootPath()+"inhouse")



#The commandline will be written as universal OS code and then replaced per OS
batchF = rrGlobal.getCrossBatch()
batchF.osVarAdd("ErrorLevel","%ERRORLEVEL%","$?","$?")  #Note: debian uses $status and not $?
batchF.osVarAdd("rrParseOutput_Exe","rrParseOutput","rrParseOutput","rrParseOutput.app\Contents\MacOS\rrParseOutput")

batchF.setBaseFileName(fileBaseName)

batchF.addLine("<comment> This file was automatically created by a rrSubmitter Scripted Job Plugin ")
batchF.addFlag("<rrBin><rrParseOutput_Exe>")
batchF.addFlag("'<rrBin>baCPUInfo'")
batchF.addFlag("find")
batchF.addFlag("SSE4.2: Yes")
batchF.addEnd()
batchF.addFlag("<rrBin>rrPythonconsole")
batchF.addFlag("<RR_ROOT>/render_apps/scripts/pyRR_addClientToGroup.py")
batchF.add("-group Arnold -addClient <ErrorLevel>")
batchF.addEnd()

batchF.addEnd()



#Now we create a table with the information 
batchF.addFlag("<rrBin><rrParseOutput_Exe>")
batchF.addFlag("<rrBin>baCPUInfo")
batchF.addFlag("table")
batchF.addFlag(fileBaseName+"_result.csv")
batchF.addFlag("-showCmdOutput")
batchF.addFlag("-addAllClients")

batchF.addFlag("Workstation,Unique=[host]")
batchF.addFlag("Updated=[dateMonth]")
batchF.addFlag("Executed=[success]")
batchF.addFlag("Error=[error]")
batchF.addFlag("SSE4.2 support=find=SSE4.2: Yes")

batchF.addEnd()

batchF.addEnd()

if not batchF.saveWin():
    raise Exception(batchF.fileErrorMessage())

if not batchF.saveLx():
    raise Exception(batchF.fileErrorMessage())

if not batchF.saveOsx():
    raise Exception(batchF.fileErrorMessage())




#Create a job
renderApp= rrJob._RenderAppBasic()
renderApp.clear()
renderApp.name="Execute"
renderApp.type="Execute"
renderApp.executeType=rrGlobal.executeJobType.onceEachClient
renderApp.rendererName="Arnold CPU Check"



newJob=  rr.getNewJob()
newJob.overrideIcon=overrideIcon;
newJob.sceneName=batchF.getOSFileName(0);
newJob.renderApp=renderApp
newJob.companyProjectName="rrCommand"
newJob.imageFileName=fileBaseName+"_result.csv"
newJob.imageSingleOutputFile=True
newJob.splitImageFileInto_DirFileExt(False)
newJob.uiIsChecked= True
newJob.layer="Arnold Check"

rr.setSubmitterParameter("MaxClientsAtATime=0~5")




rr.jobAll_set(999,newJob);  # If the index of the job is higher than the number of jobs,
                            # then a new job is added to the end of the job list. So I use 999.
